using System;
using System.Net.Http;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Components.WebAssembly.Hosting;
using Microsoft.Extensions.DependencyInjection;
using MyFirstApp.Client.Services;
using MyFirstApp.Client.ViewModels;
using Syncfusion.Blazor;    

namespace MyFirstApp.Client
{
    public class Program
    {
        public static async Task Main(string[] args)
        {
            Syncfusion.Licensing.SyncfusionLicenseProvider.RegisterLicense("NDM1MDY2QDMxMzkyZTMxMmUzMFY0cENna295YzZCUTJRSzhNemNUdThmOWsxaC9ObWpwODlKTldMNDVhems9");
            var builder = WebAssemblyHostBuilder.CreateDefault(args);
            builder.RootComponents.Add<App>("app");
            builder.Services.AddSyncfusionBlazor();

            builder.Services
                .AddTransient<UserService>()
                .AddTransient<UserViewModel>()
                .AddTransient<UserFormViewModel>()
                .AddTransient<ConfirmationComponentViewModel>()
                .AddScoped(sp => new HttpClient { BaseAddress = new Uri(builder.HostEnvironment.BaseAddress) });

            await builder.Build().RunAsync();
        }
    }
}
